package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.VastAdLoadError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.media.MediaCacheRepository

/**
 * Maps a media error to a VAST error that is reported to the backend
 */
internal fun mapMediaErrorToVastError(mediaResult: MediaCacheRepository.Result.Failure): VastAdLoadError {
    return when(mediaResult) {
        MediaCacheRepository.Result.Failure.UnableToRenameTmpFileError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_TMP_FILE_NOT_RENAMED_DISK_ERROR
        }
        MediaCacheRepository.Result.Failure.FileNotCreatedDiskError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_NOT_CREATED_DISK_ERROR
        }
        MediaCacheRepository.Result.Failure.FileNotCreatedIOError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_NOT_CREATED_IO_DISK_ERROR
        }
        MediaCacheRepository.Result.Failure.FileNotCreatedSecurityError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_NOT_CREATED_SECURITY_DISK_ERROR
        }
        MediaCacheRepository.Result.Failure.FileNotCreatedUnknownError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_NOT_CREATED_UNKNOWN_DISK_ERROR
        }
        MediaCacheRepository.Result.Failure.HttpDiskIOError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_HTTP_DISK_IO_ERROR
        }
        MediaCacheRepository.Result.Failure.HttpDiskSecurityError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_HTTP_DISK_SECURITY_ERROR
        }
        MediaCacheRepository.Result.Failure.UnknownMediaFetchError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_UNKNOWN_MEDIA_FETCH_ERROR
        }
        MediaCacheRepository.Result.Failure.HttpClientError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_CLIENT_HTTP_ERROR
        }
        MediaCacheRepository.Result.Failure.HttpServerError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_SERVER_HTTP_ERROR
        }
        MediaCacheRepository.Result.Failure.NoNetworkError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_NO_NETWORK_HTTP_ERROR
        }
        MediaCacheRepository.Result.Failure.InvalidUrlError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_INVALID_URL_ERROR
        }
        MediaCacheRepository.Result.Failure.NotFound -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_NOT_FOUND_ERROR
        }
        MediaCacheRepository.Result.Failure.UnknownHostHttpError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_UNKNOWN_HOST_HTTP_ERROR
        }
        MediaCacheRepository.Result.Failure.HttpSocketError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_SOCKET_HTTP_ERROR
        }
        MediaCacheRepository.Result.Failure.HttpSslError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_HTTP_SSL_ERROR
        }
        MediaCacheRepository.Result.Failure.MediaFetchTimeoutError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_FILE_TIMEOUT_ERROR
        }
        MediaCacheRepository.Result.Failure.MediaFetchNumberParseError -> {
            VastAdLoadError.VAST_AD_LOAD_MEDIA_NUMBER_PARSE_ERROR
        }

        // No else, map every error exhaustively for logging/analytics
    }
}