package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render

import android.app.Activity
import android.content.Context
import com.moloco.sdk.internal.scheduling.DispatcherProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Destroyable
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.BaseWebView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.CreativeTypeResolver
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.WebViewRepository
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidBridge
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidInline
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.staticrenderer.StaticWebView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.CreativeType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.VastResource
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.cancel
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

internal fun VastResource.tryPrepareImageResource(width: Int, height: Int): PreparedVastResource? =
    if (this is VastResource.Static && resource.creativeType == CreativeType.Image) {
        PreparedVastResource.Image(resource.resource, width, height)
    } else {
        null
    }

// TODO. As ugly as it gets.
internal fun VastResource.tryExtractMraid(): String? = when (this) {
    is VastResource.Html -> if (CreativeTypeResolver.isMraid(resource.resource)) {
        resource.resource
    } else {
        null
    }
    is VastResource.IFrame -> if (CreativeTypeResolver.isMraid(resource.resource)) {
        resource.resource
    } else {
        null
    }
    is VastResource.Static -> if (resource.creativeType == CreativeType.JS && CreativeTypeResolver.isMraid(
            resource.resource
        )
    ) {
        resource.resource
    } else {
        null
    }
}

// TODO. Proper solution.
internal suspend fun VastResource.prepareVastResource(
    context: Context,
    customUserEventBuilderService: CustomUserEventBuilderService,
    externalLinkHandler: ExternalLinkHandler,
    width: Int,
    height: Int,
    // TODO. Proper solution.
    // quick fix to support mraid/html creative ad redirects / webview errors.
    onWebViewClick: () -> Unit,
    onWebViewError: (error: MolocoAdSubErrorType) -> Unit
): PreparedVastResourceHandler? {
    val imgRes = tryPrepareImageResource(width, height)
    if (imgRes != null) return PreparedVastResourceHandler(imgRes, null)

    var mraidHtml: String?
    withContext(DispatcherProvider().default) {
        mraidHtml = tryExtractMraid()
    }

    // Going back to main.

    var mraidInline: MraidInline? = null
    var staticWebView: BaseWebView? = null
    var staticWebViewListenerScope: CoroutineScope? = null
    val webViewId: Int?

    // Spare me for my naming.
    val mraidAdm = mraidHtml
    // Not an mraid ad, simple static html.
    val webView = if (mraidAdm == null) {
        StaticWebView(
            context.applicationContext,
            customUserEventBuilderService,
            externalLinkHandler
        ).also { wv ->
            staticWebView = wv

            val scope = CoroutineScope(DispatcherProvider().main)
            staticWebViewListenerScope = scope

            wv.clickthroughEvent
                .onEach { onWebViewClick() }
                .launchIn(scope)

            scope.launch {
                wv.unrecoverableError.first {
                    it != null
                }?.run {
                    // Propagate the first unrecoverable error
                    onWebViewError(this)
                }
            }

            wv.loadVastResource(this)
        }
    } else {
        // TODO. IMPORTANT. Proper listener attachment etc.
        //  Or block expand at least for VAST player.
        //  You might encounter crash otherwise.
        mraidInline = MraidInline(
            context as Activity,
            mraidAdm,
            onNeedToDetachAdViewBeforeExpand = {},
            onExpandAdViewClosed = {},
            onClick = onWebViewClick,
            onError = onWebViewError,
            forceBlockExpand = true,
            externalLinkHandler,
            mraidBridge = MraidBridge(context, CoroutineScope(DispatcherProvider().main))
        )

        mraidInline.load() as? BaseWebView
    }

    webViewId = webView?.let {
        WebViewRepository.put(it)
    }

    val destroyable = object : Destroyable {
        override fun destroy() {
            webViewId?.let {
                WebViewRepository.remove(it)
            }

            mraidInline?.destroy()
            mraidInline = null

            staticWebView?.destroy()
            staticWebView = null

            staticWebViewListenerScope?.cancel()
            staticWebViewListenerScope = null
        }
    }

    return webViewId?.let {
        PreparedVastResourceHandler(
            PreparedVastResource.Html(it),
            destroyable
        )
    }
}

// TODO. Refactor. Ugly.
//  Basically response for the function above which takes care of internal webview resources releases and whatnot.
internal class PreparedVastResourceHandler(
    val resource: PreparedVastResource,
    private val destroyable: Destroyable? = null
) : Destroyable {

    override fun destroy() {
        destroyable?.destroy()
    }
}
