package com.moloco.sdk.internal.android_context

import android.content.Context
import androidx.annotation.VisibleForTesting
import androidx.startup.Initializer
import com.moloco.sdk.internal.MolocoLogger

internal class ApplicationContextStartupComponentInitialization : Initializer<Unit> {
    override fun create(context: Context) {
        ApplicationContext(context)

        isInitialized = true
        MolocoLogger.info(TAG, "initialized")
    }

    override fun dependencies(): List<Class<out Initializer<*>>> {
        return emptyList()
    }

    companion object {
        private const val TAG = "ApplicationContextStartupComponentInitialization"

        @VisibleForTesting(otherwise = VisibleForTesting.PRIVATE)
        internal var isInitialized = false
            private set
    }
}
