package com.moloco.sdk.internal.services.bidtoken.providers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.services.BatteryInfoService

/**
 * The battery information that's needed to construct the bid token
 */
internal data class BatteryInfoSignal(
    val maxBatteryLevel: Int,
    val batteryStatus: Int,
    val isPowerSaveMode: Boolean
)

/**
 * This class provides the battery information signal
 */
internal class BatteryInfoSignalProvider(private val batteryInfoService: BatteryInfoService): ClientBidTokenSignalProvider<BatteryInfoSignal> {
    private var cachedSignal = getBatteryInfoSignal()

    override fun needsRefresh(): Boolean {
        val currentSignal = getBatteryInfoSignal()
        val needsRefresh = cachedSignal != currentSignal
        MolocoLogger.debugBuildLog(TAG, "[CBT][BIS]: needsRefresh: $needsRefresh")
        return needsRefresh
    }

    override fun tryUpdateSignalState() {
        cachedSignal = getBatteryInfoSignal()
    }

    override fun provideSignal(): BatteryInfoSignal = cachedSignal

    override fun logTag(): String = TAG

    private fun getBatteryInfoSignal(): BatteryInfoSignal {
        return BatteryInfoSignal(
            maxBatteryLevel =  batteryInfoService.maxBatteryLevel(),
            batteryStatus = batteryInfoService.batteryStatus(),
            isPowerSaveMode = batteryInfoService.isLowerPowerModeEnabled()
        ).apply {
            MolocoLogger.debugBuildLog(TAG, "[CBT][BIS]: blev: $maxBatteryLevel, bst: $batteryStatus, psm: $isPowerSaveMode")
        }
    }

    companion object {
        private const val TAG = "BInfoSignalProvider"
    }

}