package com.moloco.sdk.internal.services.bidtoken.providers

/**
 * Provides the signal for the client bid token generation.
 * Each signal provider provides a unique required signal needed to construct
 * the bid token on the client
 */
internal interface ClientBidTokenSignalProvider<T> {

    /**
     * Returns true if the signal state needs refresh. false otherwise.
     */
    fun needsRefresh(): Boolean

    /**
     * Updates the signal state if needed.
     */
    fun tryUpdateSignalState()

    /**
     * Provides the signal
     */
    fun provideSignal(): T

    /**
     * Returns the log tag for the signal provider so that the logs can be easily identified
     */
    fun logTag(): String
}
