package com.moloco.sdk.internal.services.bidtoken.providers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.services.DeviceInfoService
import com.moloco.sdk.internal.services.ScreenInfoService
import com.moloco.sdk.internal.services.ScreenOrientation


internal data class DeviceSignalInfo(
    val orientation: ScreenOrientation,
    val locale: String,
    val keyboardLocale: String?,
)

internal class DeviceSignalProvider(private val deviceInfoService: DeviceInfoService,
                                    private val screenInfoService: ScreenInfoService
) : ClientBidTokenSignalProvider<DeviceSignalInfo> {

    private var cachedSensorSignal = getDeviceSignal()
    override fun needsRefresh(): Boolean {
        val currentSignal = getDeviceSignal()
        val needsRefresh = currentSignal != cachedSensorSignal
        MolocoLogger.debugBuildLog(TAG, "[CBT] DSP needsRefresh: $needsRefresh, with current: $currentSignal, cached: $cachedSensorSignal")
        return needsRefresh
    }

    override fun tryUpdateSignalState() {
        cachedSensorSignal = getDeviceSignal()
    }

    override fun provideSignal(): DeviceSignalInfo = cachedSensorSignal

    override fun logTag(): String = TAG

    private fun getDeviceSignal(): DeviceSignalInfo {
        return DeviceSignalInfo(
            orientation = screenInfoService.orientation(),
            locale =  deviceInfoService.deviceLocale(),
            keyboardLocale = deviceInfoService.deviceKeyboardLocale()
        )
    }

    companion object {
        private const val TAG = "DSignalProvider"
    }
}