package com.moloco.sdk.internal.services.bidtoken.providers

import com.moloco.sdk.internal.MolocoLogger.debugBuildLog
import com.moloco.sdk.internal.services.bidtoken.PrivacyProvider
import com.moloco.sdk.publisher.privacy.MolocoPrivacy

internal class PrivacyStateSignalProvider(private val privacyProvider: PrivacyProvider) : ClientBidTokenSignalProvider<MolocoPrivacy.PrivacySettings> {
    private val TAG = "PrivacyStateSignalProvider"
    // Initiating to have privacy to compare to upon bidToken() invocations.
    private var privacy = privacyProvider.privacy

    override fun needsRefresh(): Boolean {
        val oldPrivacy = privacy
        val newPrivacy = privacyProvider.privacy

        return (oldPrivacy != newPrivacy).also {
            debugBuildLog(TAG, if (it) "[CBT] privacy updated" else "[CBT] privacy didn't change")
        }
    }

    override fun tryUpdateSignalState() {
        privacy = privacyProvider.privacy
    }

    override fun provideSignal(): MolocoPrivacy.PrivacySettings = privacy

    override fun logTag(): String = TAG
}