package com.moloco.sdk.internal.services.config.handlers

import com.moloco.sdk.Init

/**
 * Interface for handling the parsing of remote configurations.
 *
 * Implementations of this interface are responsible for parsing the configuration
 * received from remote sources and providing the appropriate configuration type.
 */
internal interface ConfigHandler {
    /**
     * Handles the configuration data from the SDK initialization response.
     *
     * @param sdkInitResponse The SDK initialization response containing configuration data.
     * @return The parsed configuration object.
     */
    fun handleConfig(sdkInitResponse: Init.SDKInitResponse): Any

    /**
     * Provides the class type of the configuration object that this handler is responsible for.
     *
     * @return The class type of the configuration object.
     */
    fun getConfigType(): Class<*>
}
