package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

private val HEX_ARRAY = "0123456789ABCDEF".toCharArray()

// https://stackoverflow.com/questions/9655181/how-to-convert-a-byte-array-to-a-hex-string-in-java
fun ByteArray.toHex(): String {
    val hexChars = CharArray(size * 2)
    for (j in 0 until size) {
        val v: Int = this[j].toInt() and 0xFF
        hexChars[j * 2] = HEX_ARRAY[v ushr 4]
        hexChars[j * 2 + 1] = HEX_ARRAY[v and 0x0F]
    }
    return String(hexChars)
}
