package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import android.content.Context
import com.moloco.sdk.internal.ortb.model.Bid
import com.moloco.sdk.service_locator.SdkObjectFactory
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.AdShowListener
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.AdWebViewOptions
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.FullscreenAd
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.VastAdShowListener
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.VastOptions
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Watermark
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidActivity
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidBaseAd
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidBridge
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidFullscreenContentControllerImpl
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidPlacementType
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.flow.MutableStateFlow

internal interface FullscreenAdFactory {
    fun createMraidFullScreenAd(context: Context,
                                scope: CoroutineScope,
                                bid: Bid,
                                externalLinkHandler: ExternalLinkHandler,
                                watermark: Watermark,
                                isAdDisplaying: MutableStateFlow<Boolean>,
    ) : FullscreenAd<AdShowListener, AdWebViewOptions>

    fun createVastFullscreenAd(context: Context,
                               bid: Bid,
                               vastMediaStreamingEnabled: Boolean,
                               watermark: Watermark
    ) : FullscreenAd<VastAdShowListener, VastOptions>

    fun createStaticFullscreenAd(context: Context,
                                 customUserEventBuilderService: CustomUserEventBuilderService,
                                 adm: String,
                                 externalLinkHandler: ExternalLinkHandler,
                                 watermark: Watermark
    ) : FullscreenAd<AdShowListener, AdWebViewOptions>
}

internal class FullscreenAdFactoryImpl: FullscreenAdFactory {
    override fun createMraidFullScreenAd(context: Context,
                                scope: CoroutineScope,
                                bid: Bid,
                                externalLinkHandler: ExternalLinkHandler,
                                watermark: Watermark,
                                isAdDisplaying: MutableStateFlow<Boolean>,
    ): FullscreenAd<AdShowListener, AdWebViewOptions> {

        // must be created on main thread due to webView
        val mraidBridge = MraidBridge(context, scope)

        val mraidBaseAd = object : MraidBaseAd(
            context,
            bid.adm,
            mraidPlacementType = MraidPlacementType.Interstitial,
            externalLinkHandler = externalLinkHandler,
            mraidBridge = mraidBridge,
        ) {
            override fun closeFullscreenAdRepresentation() {
                super.closeFullscreenAdRepresentation()
                isAdDisplaying.value = false
            }
        }

        val mraidFullscreenController = MraidFullscreenContentControllerImpl(
            hasClickThrough = true,
            closeFullscreenAdRepresentation = mraidBaseAd::closeFullscreenAdRepresentation,
            scope = scope,
            goNextActionDelaySeconds = 0.coerceAtLeast(0).toUInt(), // TODO: Remove useless value
            webView = mraidBridge.webView,
            mraidJsCommands = mraidBridge.mraidJsCommands
        )

        val mraidAdLoader = MraidAdLoad(scope, bid, SdkObjectFactory.AdLoadModule.decLoader, mraidBaseAd::loadAndReadyMraid)

        val fullscreenAd = MraidFullscreenAd(
            context,
            watermark,
            mraidAdLoader,
            mraidBaseAd,
            mraidFullscreenController,
            MraidActivity
        )

        return fullscreenAd
    }

    override fun createVastFullscreenAd(context: Context,
                                        bid: Bid,
                                        vastMediaStreamingEnabled: Boolean,
                                        watermark: Watermark): FullscreenAd<VastAdShowListener, VastOptions> =
        VastFullscreenAd(context, bid, SdkObjectFactory.Media.mediaConfigSingleton.isStreamingEnabled, watermark)

    override fun createStaticFullscreenAd(context: Context,
                                          customUserEventBuilderService: CustomUserEventBuilderService,
                                          adm: String,
                                          externalLinkHandler: ExternalLinkHandler,
                                          watermark: Watermark): FullscreenAd<AdShowListener, AdWebViewOptions> =
        StaticFullscreenAd(context, customUserEventBuilderService, adm, externalLinkHandler, watermark)


}
