package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import android.annotation.SuppressLint
import android.content.Context
import com.moloco.sdk.internal.Result
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.CreativeType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.FullscreenAd
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.VastAdShowListener
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.VastOptions
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.XenossBannerView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.AdController
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.AdControllerEvent
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.vastAdPlaylistController
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach

/**
 * @param options mostly for changing renderer behaviour, like button customization, when to show close button, mute etc. Same as for [FullscreenAd.show]
 */
@SuppressLint("ViewConstructor")
internal class VastBannerView(
    private val context: Context,
    private val customUserEventBuilderService: CustomUserEventBuilderService,
    private val options: VastOptions,
    private val externalLinkHandler: ExternalLinkHandler,
    private val scope: CoroutineScope,
    override val adLoader: VastAdLoad,
) : XenossBannerView<VastAdShowListener>(context,scope ) {
    init {
        tag = "MolocoVastBannerView"
    }

    override val creativeType: CreativeType = CreativeType.VAST

    private var adController: AdController? = null

    override fun destroy() {
        super.destroy()
        adController?.destroy()
        adController = null
    }

    override fun prepareAdViewForDisplay() {
        val ad = when(val vastAdResult = adLoader.vastAdLoadResult) {
            is Result.Failure -> {
                val error = vastAdResult.value
                adShowListener?.onShowError(error)
                return
            }
            is Result.Success -> {
                vastAdResult.value
            }
        }

        val adController = vastAdPlaylistController(
            ad,
            externalLinkHandler,
            context,
            customUserEventBuilderService,
            mute = options.startMuted,
            overrideLinearGoNextActionEnabled = options.overrideLinearGoNextActionEnabled,
            overrideLinearGoNextActionEnabledDelaySeconds = options.overrideLinearGoNextActionEnabledDelaySeconds,
            companionGoNextActionDelaySeconds = options.companionGoNextActionDelaySeconds,
            decGoNextActionDelaySeconds = options.decGoNextActionDelaySeconds,
            autoStoreOnSkip = options.autoStoreOnSkip,
            autoStoreOnComplete = options.autoStoreOnComplete
        )
        this.adController = adController

        adView = options.VastRenderer(context, adController)

        listenToPlayerEvents()

        adController.show()
    }

    private fun listenToPlayerEvents() {
        adController?.event?.onEach { event ->
            when (event) {
                AdControllerEvent.Skip -> adShowListener?.onVastCompletionStatus(skipped = true)
                AdControllerEvent.Complete -> adShowListener?.onVastCompletionStatus(
                    skipped = false
                )
                AdControllerEvent.ClickThrough -> adShowListener?.onClick()
                is AdControllerEvent.Error -> adShowListener?.onShowError(event.error)
                // I don't care for these events for updating ad displaying state as opposed to VastFullscreenAd.
                AdControllerEvent.LinearDisplayStarted -> { /* no-op */ }
                AdControllerEvent.CompanionDisplayStarted -> { /* no-op */ }
                AdControllerEvent.DECDisplayStarted -> { /* no-op */ }
                AdControllerEvent.Replay -> { /* no-op */ }
                AdControllerEvent.Dismiss -> { /* no-op */ }
            }
        }?.launchIn(scope)
    }
}
