package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors

// TODO: This can be better refactored to use a sealed class
internal enum class MraidAdError: MolocoAdSubErrorType {
    MRAID_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR,
    MRAID_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR,
    MRAID_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR,
    MRAID_WEBVIEW_PAGE_DIDNT_LOAD_ERROR,
    MRAID_WEBVIEW_INTERNAL_TIMEOUT_ERROR,

    // Fullscreen specific errors
    MRAID_FULLSCREEN_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR,
    MRAID_FULLSCREEN_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR,
    MRAID_FULLSCREEN_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR,
    MRAID_FULLSCREEN_WEBVIEW_PAGE_DIDNT_LOAD_ERROR,
    MRAID_FULLSCREEN_AD_ACTIVITY_SHOW_FAILED_ERROR,

    // Banner specific errors
    MRAID_BANNER_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR,
    MRAID_BANNER_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR,
    MRAID_BANNER_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR,
    MRAID_BANNER_WEBVIEW_PAGE_DIDNT_LOAD_ERROR,
    ;

    override val metricsRepresentation: String
        get() = name
}

/**
 * Converts the MRAID error into a fullscreen specific error
 */
internal fun MraidAdError.toMraidFullscreenError(): MraidAdError {
    return when (this) {
        MraidAdError.MRAID_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR -> MraidAdError.MRAID_FULLSCREEN_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR
        MraidAdError.MRAID_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR -> MraidAdError.MRAID_FULLSCREEN_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR
        MraidAdError.MRAID_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR -> MraidAdError.MRAID_FULLSCREEN_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR
        MraidAdError.MRAID_WEBVIEW_PAGE_DIDNT_LOAD_ERROR -> MraidAdError.MRAID_FULLSCREEN_WEBVIEW_PAGE_DIDNT_LOAD_ERROR
        MraidAdError.MRAID_WEBVIEW_INTERNAL_TIMEOUT_ERROR -> MraidAdError.MRAID_WEBVIEW_INTERNAL_TIMEOUT_ERROR

        MraidAdError.MRAID_FULLSCREEN_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR -> this
        MraidAdError.MRAID_FULLSCREEN_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR -> this
        MraidAdError.MRAID_FULLSCREEN_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR -> this
        MraidAdError.MRAID_FULLSCREEN_WEBVIEW_PAGE_DIDNT_LOAD_ERROR -> this
        MraidAdError.MRAID_FULLSCREEN_AD_ACTIVITY_SHOW_FAILED_ERROR -> this

        // TODO: This can be better refactored to use a sealed class, this is a hacky way to convert the error
        MraidAdError.MRAID_BANNER_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR -> MraidAdError.MRAID_FULLSCREEN_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR
        MraidAdError.MRAID_BANNER_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR -> MraidAdError.MRAID_FULLSCREEN_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR
        MraidAdError.MRAID_BANNER_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR -> MraidAdError.MRAID_FULLSCREEN_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR
        MraidAdError.MRAID_BANNER_WEBVIEW_PAGE_DIDNT_LOAD_ERROR -> MraidAdError.MRAID_FULLSCREEN_WEBVIEW_PAGE_DIDNT_LOAD_ERROR
    }
}

/**
 * Converts the MRAID error into a banner specific error
 */
// TODO: This can be better refactored to use a sealed class
internal fun MraidAdError.toMraidBannerError(): MraidAdError {
    return when (this) {
        MraidAdError.MRAID_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR -> MraidAdError.MRAID_BANNER_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR
        MraidAdError.MRAID_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR -> MraidAdError.MRAID_BANNER_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR
        MraidAdError.MRAID_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR -> MraidAdError.MRAID_BANNER_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR
        MraidAdError.MRAID_WEBVIEW_PAGE_DIDNT_LOAD_ERROR -> MraidAdError.MRAID_BANNER_WEBVIEW_PAGE_DIDNT_LOAD_ERROR
        MraidAdError.MRAID_WEBVIEW_INTERNAL_TIMEOUT_ERROR -> MraidAdError.MRAID_WEBVIEW_INTERNAL_TIMEOUT_ERROR

        // TODO: This can be better refactored to use a sealed class, this is a hacky way to convert the error
        MraidAdError.MRAID_FULLSCREEN_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR -> MraidAdError.MRAID_BANNER_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR
        MraidAdError.MRAID_FULLSCREEN_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR -> MraidAdError.MRAID_BANNER_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR
        MraidAdError.MRAID_FULLSCREEN_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR -> MraidAdError.MRAID_BANNER_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR
        MraidAdError.MRAID_FULLSCREEN_WEBVIEW_PAGE_DIDNT_LOAD_ERROR -> MraidAdError.MRAID_BANNER_WEBVIEW_PAGE_DIDNT_LOAD_ERROR
        MraidAdError.MRAID_FULLSCREEN_AD_ACTIVITY_SHOW_FAILED_ERROR -> this

        MraidAdError.MRAID_BANNER_WEBVIEW_CLIENT_UNRECOVERABLE_ERROR -> this
        MraidAdError.MRAID_BANNER_WEBVIEW_CLIENT_RENDER_PROCESS_GONE_ERROR -> this
        MraidAdError.MRAID_BANNER_WEBVIEW_LOAD_DATA_WITH_BASE_URL_ERROR -> this
        MraidAdError.MRAID_BANNER_WEBVIEW_PAGE_DIDNT_LOAD_ERROR -> this
    }

}