package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid

import android.content.Context
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.DEC
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.PlaylistItem
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.dec.DECControllerImpl
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService

internal data class MraidAdData(
    val dec: DEC? = null
)

internal fun MraidAdData.toPlaylist(
    mraidFullscreenContentController: MraidFullscreenContentController,
    decGoNextActionDelaySeconds: Int,
    context: Context,
    externalLinkHandler: ExternalLinkHandler,
    customUserEventBuilderService: CustomUserEventBuilderService,
) : List<PlaylistItem> = listOfNotNull(
    PlaylistItem.Mraid(
        mraidFullscreenContentController
    ),
    dec?.let {
        PlaylistItem.DEC(
            DECControllerImpl(
                it,
                null, // TODO: https://mlc.atlassian.net/browse/SDK-2678
                decGoNextActionDelaySeconds.coerceAtLeast(0).toUInt(),
                context,
                customUserEventBuilderService,
                externalLinkHandler
            )
        )
    }
)
