package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui

import android.app.Activity
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.ui.platform.LocalWindowInfo
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.hideSystemUI

@Composable
internal fun Activity.HideSystemUI() {
    val isWindowFocused = LocalWindowInfo.current.isWindowFocused

    // Since Composable can run on any thread, let's wrap hideSystemUI() call with Launched effect
    // to avoid cross threading issues.
    LaunchedEffect(isWindowFocused) {
        if (isWindowFocused) {
            hideSystemUI()
        }
    }
}
