package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui

import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.modifiers.buttonGlobalPositionModifier
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.defaultButton
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService.UserInteraction.Button
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService.UserInteraction.Button.ButtonType

/**
 * A trackable button whose rendering / unrendering states are recorded for analytics
 */
@Composable
fun TrackableButton(
    modifier: Modifier = Modifier,
    buttonType: ButtonType,
    onButtonRendered: (Button) -> Unit,
    content: @Composable (modifier: Modifier) -> Unit,
) {
    var buttonLayout by remember {
        mutableStateOf(defaultButton(buttonType))
    }

    content(
        buttonGlobalPositionModifier(modifier, buttonLayout) {
            buttonLayout = it
            onButtonRendered(it)
        }
    )
}
