package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.dec

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Destroyable
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.ButtonRecorder
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.AdPartClickThrough
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.VastPrivacyIcon
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.companion.CompanionGoNextAction
import kotlinx.coroutines.flow.Flow

internal interface DECController : DECViewModel, Destroyable {
    val event: Flow<DECControllerEvent>

    fun trackSkipToDEC()
}

internal enum class DECControllerEvent { DisplayStarted, ClickThrough }

interface DECViewModel : CompanionGoNextAction, AdPartClickThrough, VastPrivacyIcon, ButtonRecorder {
    fun onDisplayStarted()

    val appIconUri: String?
    val appName: String?
    val ctaText: String?
}
