package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.linear

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Destroyable
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.VastAdShowError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.ButtonRecorder
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.AdPartClickThrough
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.GoNextAction
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.PlaybackProgress
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ValueWrapper
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.VastPrivacyIcon
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.StateFlow

interface LinearController : LinearViewModel, Destroyable {
    val event: Flow<LinearControllerEvent>
    val isPlaying: StateFlow<Boolean>
    val positionMillis: Int

    fun replay()
}

sealed class LinearControllerEvent {
    object DisplayStarted : LinearControllerEvent()
    data class Error(val error: VastAdShowError) : LinearControllerEvent()
    object Complete : LinearControllerEvent()
    object Skip : LinearControllerEvent()
    object ClickThrough : LinearControllerEvent()
}

// TODO. Definitely rename to something like state/interactor whatever.
// It's the interface for user interactions.
interface LinearViewModel : GoNextAction, AdPartClickThrough, VastPrivacyIcon, ButtonRecorder {
    val videoUri: String
    val isStreamingEnabled: Boolean

    // TODO. Rename to something like seekToMillis.
    val startFromMillis: StateFlow<ValueWrapper<Long>>

    val mute: StateFlow<Boolean>
    fun onMuteChange(mute: Boolean)

    fun onSkip()

    fun onIsPlaying(isPlaying: Boolean)
    fun onProgress(progress: PlaybackProgress)
    fun onError(error: VastAdShowError)

    fun onDisplayStarted()

    fun onVideoPlayerVisible()
    fun onVideoPlayerNotVisible()
}
