package com.moloco.sdk.xenoss.sdkdevkit.android.core

import com.moloco.sdk.internal.MolocoLogger

fun UserAgentService(): UserAgentService = Instance

private val Instance by lazy {
    WebBrowserUserAgentService()
}

interface UserAgentService {
    operator fun invoke(): String
}

internal class WebBrowserUserAgentService : UserAgentService {

    private val TAG = "WebBrowserUserAgentService"

    // TODO. Check if it would be beneficial to use these lazy blocks in non concurrent mode.
    private val ua: String by lazy {
        try {
            // WebSettings.getDefaultUserAgent(context) can freeze thread + cause crashes due to missing Chromium package.
            // That's why we rely on http.agent System property.
            // More info on the issue:
            // https://mlc.atlassian.net/browse/SDKS-168
            // https://groups.google.com/g/google-admob-ads-sdk/c/GYxTsgflUbk?pli=1
            val userAgent = System.getProperty("http.agent")
            if (userAgent.isNullOrBlank()) {
                FALLBACK_UA
            } else {
                userAgent
            }
        } catch (e: Exception) {
            MolocoLogger.error(TAG, e.toString())
            FALLBACK_UA
        }
    }

    override fun invoke() = ua
}

// https://github.com/moloco/moloco-sdk-android/pull/270#issuecomment-2021553513
internal const val FALLBACK_UA = ""
