package com.moloco.sdk.internal.android_context

import android.annotation.SuppressLint
import android.content.Context

// Added forceContextUpdate parameter in case ApplicationContext.update wasn't called in Jetpack Startup.
fun ApplicationContext(updateFromContext: Context? = null): Context {
    updateFromContext?.let {
        ApplicationContext.update(it)
    }

    return ApplicationContext.value
}

// Application context does not leak. Don't worry.
@SuppressLint("StaticFieldLeak")
private object ApplicationContext {

    // Made it volatile in case it's updated/accessed from different threads.
    // Access/modifications might be a bit slower due to reading from RAM instead of CPU cache (are you sure?),
    // but for AppContext's use-case it doesn't matter much.
    @Volatile
    lateinit var value: Context
        private set

    fun update(context: Context) {
        value = context.applicationContext
    }
}
