package com.moloco.sdk.internal.bidtoken

import com.moloco.sdk.internal.Error
import com.moloco.sdk.internal.Result

/**
 * Bid token parser for Moloco back-end generated bid tokens.
 */
internal interface BidTokenParser {
    suspend operator fun invoke(bidToken: String): Result<BidToken, Error>
}

internal class BidToken(
    val expiresAtUnixSeconds: Long
)
