package com.moloco.sdk.internal.bidtoken

import android.util.Base64
import com.moloco.sdk.internal.Error
import com.moloco.sdk.internal.Result
import com.moloco.sdk.internal.scheduling.DispatcherProvider
import kotlinx.coroutines.withContext
import org.json.JSONObject

/**
 * Version prefixed JWToken parser - current Moloco Bid Token implementation.
 * [More info](https://www.notion.so/moloco/Tech-Design-MAX-Mediation-Integration-Proposal-bf75f57e20274941aae96cd3aff9e07f?pvs=4#ad96945d8cd646cebb9eb6cf33fb21c8)
 */
internal class VersionPrefixedJWTokenParser : BidTokenParser {
    override suspend fun invoke(bidToken: String): Result<BidToken, Error> =
        withContext(Dispatcher) {
            try {
                // Moloco token version prefix is omitted.
                val (_, jwToken) = bidToken.split(':')

                val jwTokenChunks = jwToken.split(".")

                val payload = Base64.decode(jwTokenChunks[1], Base64.DEFAULT).decodeToString()

                val expiresAtUnixSeconds = JSONObject(payload).getLong("exp")

                Result.Success(
                    BidToken(expiresAtUnixSeconds)
                )
            } catch (e: Exception) {
                Result.Failure(Error(e.toString(), -1))
            }
        }
}

private val Dispatcher = DispatcherProvider().io
