package com.moloco.sdk.internal.publisher

import com.moloco.sdk.publisher.AdShowListener
import com.moloco.sdk.publisher.MolocoAd
import com.moloco.sdk.publisher.MolocoAdError

/**
 * Wraps the origin listener and fires url tracking event upon calling the respective listener's callback.
 */
internal fun AdShowListenerTracker(
    originListener: AdShowListener?,
): AdShowListener = AdShowListenerTrackerImpl(
    originListener,
)

private class AdShowListenerTrackerImpl(
    private val originListener: AdShowListener?,
) : AdShowListener {

    override fun onAdShowSuccess(molocoAd: MolocoAd) {
        originListener?.onAdShowSuccess(molocoAd)
    }

    override fun onAdShowFailed(molocoAdError: MolocoAdError) {
        originListener?.onAdShowFailed(molocoAdError)
    }

    override fun onAdHidden(molocoAd: MolocoAd) {
        originListener?.onAdHidden(molocoAd)
    }

    override fun onAdClicked(molocoAd: MolocoAd) {
        originListener?.onAdClicked(molocoAd)
    }
}

internal class BUrlData(val burl: String, val price: Float?)
