package com.moloco.sdk.internal.publisher

import android.content.Context
import com.moloco.sdk.internal.DefaultMolocoFullscreenAdAggregatedOptions
import com.moloco.sdk.internal.ortb.model.SdkEvents
import com.moloco.sdk.internal.services.AnalyticsApplicationLifecycleTracker
import com.moloco.sdk.internal.toFullscreenAggregatedOptions
import com.moloco.sdk.publisher.AdFormatType
import com.moloco.sdk.publisher.AdShowListener
import com.moloco.sdk.publisher.InterstitialAd
import com.moloco.sdk.publisher.InterstitialAdShowListener
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Watermark
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest

/**
 * @param adDataHolder is only visible for it to be mocked by unit tests
 */
internal fun InterstitialAd(
        context: Context,
        appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
        customUserEventBuilderService: CustomUserEventBuilderService,
        adUnitId: String,
        externalLinkHandler: ExternalLinkHandler,
        persistentHttpRequest: PersistentHttpRequest,
        adDataHolder: FullscreenAdDataHolder<InterstitialAdShowListener> = FullscreenAdDataHolder(),
        watermark: Watermark,
        adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
): InterstitialAd = InterstitialAdImpl(
        FullscreenAdImpl(
                context,
                appLifecycleTrackerService,
                customUserEventBuilderService,
                adUnitId,
                persistentHttpRequest = persistentHttpRequest,
                externalLinkHandler,
                generateAggregatedOptions = { playerExt ->
                    playerExt?.toFullscreenAggregatedOptions()
                            ?: DefaultMolocoFullscreenAdAggregatedOptions()
                },
                adDataHolder = adDataHolder,
                adFormatType = AdFormatType.INTERSTITIAL,
                watermark = watermark,
                adCreateLoadTimeoutManager = adCreateLoadTimeoutManager,
                )
)

internal class InternalInterstitialAdShowListenerTracker<T : AdShowListener>(
    val adShowListener: T,
    private val appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
    private val customUserEventBuilderService: CustomUserEventBuilderService,
    provideSdkEvents: () -> SdkEvents?,
    provideBUrlData: () -> BUrlData?,
    private val adFormatType: AdFormatType
): InternalAdShowListener by InternalAdShowListenerTracker(
    adShowListener,
    appLifecycleTrackerService,
    customUserEventBuilderService,
    provideSdkEvents,
    provideBUrlData,
    adType = adFormatType,
)

internal fun InterstitialAdShowListenerTracker(
    originListener: InterstitialAdShowListener?,
): InterstitialAdShowListener = object :
    InterstitialAdShowListener,
    AdShowListener by AdShowListenerTracker(
        originListener,
    ) {}

private class InterstitialAdImpl(private val fullscreenAd: FullscreenAdImpl<InterstitialAdShowListener>) :
    InterstitialAd,
    CreateAdObjectTime by fullscreenAd,
    com.moloco.sdk.publisher.FullscreenAd<InterstitialAdShowListener> by fullscreenAd {

    override fun show(listener: InterstitialAdShowListener?) {
        fullscreenAd.show(
            InterstitialAdShowListenerTracker(
                originListener = listener,
            )
        )
    }
}
