package com.moloco.sdk.internal.publisher.nativead.model

/**
 * Class built per spec:
 * https://www.iab.com/wp-content/uploads/2018/03/OpenRTB-Native-Ads-Specification-Final-1.2.pdf
 */
class NativeOrtbResponse(
    val version: String?,
    val assets: List<Asset>,
    val link: Link?,
    val impressionTrackerUrls: List<String>,
    val eventTrackers: List<EventTracker>,
    val privacyUrl: String?
) {
    sealed class Asset(
        val id: Int,
        val required: Boolean,
    ) {
        class Title(
            id: Int,
            required: Boolean,
            val text: String,
            val length: Int?
        ) : Asset(id, required)

        class Data(
            id: Int,
            required: Boolean,
            val type: Int?,
            val length: Int?,
            val value: String
        ) : Asset(id, required)

        class Image(
            id: Int,
            required: Boolean,
            val type: Int?,
            val url: String,
            val w: Int?,
            val h: Int?,
        ) : Asset(id, required)

        class Video(
            id: Int,
            required: Boolean,
            val vastTag: String
        ) : Asset(id, required)
    }

    /**
     * call-to-action/clickthrough/destination ad link: whatever you want to call it.
     */
    class Link(
        val url: String,
        val clickTrackerUrls: List<String>,
        val fallbackUrl: String?
    )

    class EventTracker(
        val eventType: Int,
        val methodType: Int,
        val url: String?
    )
}
