package com.moloco.sdk.internal.publisher.nativead.ui

import android.annotation.SuppressLint
import android.content.Context
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.ComposeView
import com.moloco.sdk.internal.ViewLifecycleOwner
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Watermark
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.AdController
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.OverrideVastContainerOnClick
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.VastRenderer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.defaultPlaybackControl

@SuppressLint("ViewConstructor")
internal class VideoContainer(
    context: Context,
    vastAdController: AdController,
    viewVisibilityTracker: ViewVisibilityTracker,
    viewLifecycleOwner: ViewLifecycleOwner,
    watermark: Watermark,
    onClick: (() -> Unit)?
) : FrameLayout(context) {

    init {
        viewLifecycleOwner.addLifecycleOwnerSupportTo(this)
    }

    private var videoView: ComposeView? = NativeAdComposeViewWrapper(context) { modifier ->
        VastRenderer(
            modifier = modifier,
            adViewModel = vastAdController,
            backgroundColor = Color.Black,
            adCloseCountdownButton = null,
            adSkipCountdownButton = null,
            ctaButton = null,
            overrideVastContainerOnClick = OverrideVastContainerOnClick(
                overrideLinearOnClick = onClick,
                overrideCompanionOnClick = onClick,
                overrideDECOnClick = onClick
            ),
            progressBar = null,
            muteButton = nativeVideoMuteButton(),
            playbackControl = defaultPlaybackControl(
                NativeVideoPlaybackControlUI
            ),
            viewVisibilityTracker = viewVisibilityTracker
        ).let { view -> watermark.ApplyWatermark({ view }) }
    }.also {
        addView(it, ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT))
    }

    fun destroyUnderlyingVideoComposeView() {
        removeAllViews()
        videoView?.disposeComposition()
        videoView = null
    }
}
