package com.moloco.sdk.internal.services.bidtoken

import com.moloco.sdk.publisher.privacy.MolocoPrivacy

/**
 * Bid token service relies on privacy data for bid token refresh operations.
 *
 * @constructor Create empty Privacy provider
 */
internal interface PrivacyProvider {
    val privacy: MolocoPrivacy.PrivacySettings
}

// TODO. https://mlc.atlassian.net/browse/SDK-1462
internal class MolocoPrivacyBasedPrivacyProvider : PrivacyProvider {
    override val privacy: MolocoPrivacy.PrivacySettings
        get() = MolocoPrivacy.privacySettings
}
