package com.moloco.sdk.internal.services.bidtoken.providers

import android.app.ActivityManager
import android.app.ActivityManager.MemoryInfo
import com.moloco.sdk.internal.MolocoLogger


internal class MemorySignalProvider(private val activityManager: ActivityManager) :
    ClientBidTokenSignalProvider<MemoryInfo> {

    private var cachedMemorySignal: MemoryInfo = getMemoryInfo()

    override fun needsRefresh(): Boolean {
        val currentMemorySignal = getMemoryInfo()
        MolocoLogger.debugBuildLog(TAG, "[CBT] cached lm: ${cachedMemorySignal.lowMemory}, t: ${cachedMemorySignal.threshold}, tm: ${cachedMemorySignal.totalMem}")
        MolocoLogger.debugBuildLog(TAG, "[CBT] current lm: ${currentMemorySignal.lowMemory}, t: ${currentMemorySignal.threshold}, tm: ${currentMemorySignal.totalMem}")
        val needsRefresh = currentMemorySignal.isDifferent(cachedMemorySignal)
        MolocoLogger.debugBuildLog(TAG, "[CBT] m needsRefresh: $needsRefresh")
        return needsRefresh
    }

    private fun MemoryInfo.isDifferent(other: MemoryInfo): Boolean {
        return this.lowMemory != other.lowMemory ||
                this.threshold != other.threshold ||
                this.totalMem != other.totalMem
    }

    override fun tryUpdateSignalState() {
        MolocoLogger.debugBuildLog(TAG, "[CBT] Updating m state")
        cachedMemorySignal = getMemoryInfo()
    }

    override fun provideSignal(): MemoryInfo {
        return cachedMemorySignal.apply {
            MolocoLogger.debugBuildLog(TAG, "[CBT] lm: $lowMemory, t: $threshold, tm: $totalMem")
        }
    }

    override fun logTag(): String = TAG

    private fun getMemoryInfo(): MemoryInfo {
        return try {
            MemoryInfo().apply {
                activityManager.getMemoryInfo(this)
            }
        } catch (e: Exception) {
            MolocoLogger.error(TAG, "MemoryInfo Error", e)
            MemoryInfo().apply {
                totalMem = 0
                threshold = 0
                lowMemory = false
            }
        }
    }

    companion object {
        private const val TAG = "MemorySignalProvider"
    }
}