package com.moloco.sdk.internal.services.bidtoken.providers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.services.NetworkInfo
import com.moloco.sdk.internal.services.NetworkInfoService

/**
 * Network signals needed for client bid token generation.
 */
internal data class NetworkInfoSignal(
    val mobileCountryCode: Int?,
    val mobileNetworkCode: Int?,
    val networkRestricted: Boolean,
    val networkType: NetworkInfo,

    )

/**
 * Signal provider for network information.
 */
internal class NetworkInfoSignalProvider(private val networkInfoService: NetworkInfoService) : ClientBidTokenSignalProvider<NetworkInfoSignal> {
    private var cachedNetworkSignal = getNetworkInfoSignal()

    override fun needsRefresh(): Boolean {
        val currentSignal = getNetworkInfoSignal()
        val needsRefresh = currentSignal != cachedNetworkSignal
        MolocoLogger.debugBuildLog(TAG, "[CBT] NIS needsRefresh: $needsRefresh, with nis: $currentSignal, cached: $cachedNetworkSignal")
        return needsRefresh
    }

    override fun tryUpdateSignalState() {
        cachedNetworkSignal = getNetworkInfoSignal()
    }

    override fun provideSignal(): NetworkInfoSignal {
        return cachedNetworkSignal
    }

    override fun logTag(): String = TAG

    private fun getNetworkInfoSignal(): NetworkInfoSignal = NetworkInfoSignal(
        mobileCountryCode = networkInfoService.mobileCountryCode(),
        mobileNetworkCode = networkInfoService.mobileNetworkCode(),
        networkRestricted = networkInfoService.isOnMeteredNetworkRestrictions(),
        networkType = networkInfoService.networkInfo()
    ).apply {
        MolocoLogger.debugBuildLog(TAG, "[CBT] NIS providing $this")
    }

    companion object {
        private const val TAG = "NISignalProvider"
    }
}
