package com.moloco.sdk.internal.services.bidtoken.providers

import com.moloco.sdk.internal.MolocoLogger.debugBuildLog
import com.moloco.sdk.publisher.Moloco

internal class SDKInitStateSignalProvider : ClientBidTokenSignalProvider<Boolean> {
    private val TAG = "SDKInitStateSignalProvider"
    private var sdkInitialized = Moloco.isInitialized

    override fun needsRefresh(): Boolean {
        val oldState = sdkInitialized
        val newState = Moloco.isInitialized

        return (oldState != newState).also {
            debugBuildLog(TAG, if (it) "[CBT] sdkInitialized updated from $oldState to $newState" else "[CBT] sdkInitialized didn't change (before: $oldState, after: $newState)")
        }
    }

    override fun tryUpdateSignalState() {
        sdkInitialized = Moloco.isInitialized
    }

    override fun provideSignal(): Boolean = sdkInitialized

    override fun logTag(): String = TAG
}