package com.moloco.sdk.internal.services.config

import com.moloco.sdk.Init.SDKInitResponse

/**
 * A configuration service that provides SDK configurations
 * to rest of the SDK components.
 *
 */
interface ConfigService {
    fun initialize(sdkInitResponse: SDKInitResponse)

    /**
     * Get the configuration by the given type.
     * @sample val config = configService.getConfig(OperationalMetricsConfig::class.java, DefaultConfig)
     * @return the configuration if it exists, default otherwise.
     */
    fun <T> getConfig(configType: Class<T>, default: T): T

    /**
     * Indicates whether an experiment feature flag is available or not.
     * @return True the experimental feature flag if it exists, false otherwise.
     */
    fun hasExperimentFeatureFlag(featureFlagName: String): Boolean

    /**
     * Get the experimental feature flag value by the given name.
     * @return the experimental feature flag if it exists in String format, null otherwise.
     */
    fun getExperimentalFeatureFlagValue(featureFlagName: String): String?
}