package com.moloco.sdk.internal.services.usertracker

import com.moloco.sdk.internal.services.DataStoreService

internal const val USER_IDENTIFIER_KEY = "com.moloco.sdk.mref"

internal interface UserIdentifierRepository {

    /**
     * Retrieves the persisted identifier
     */
    suspend fun get(): String?

    /**
     * Persist a new identifier
     */
    suspend fun persist(id: String)

    /**
     * Clears any existing identifier
     */
    suspend fun clear()
}

internal class UserIdentifierRepositoryImpl(
    private val dataStoreService: DataStoreService
) : UserIdentifierRepository {

    override suspend fun get(): String? {
        return dataStoreService.getString(USER_IDENTIFIER_KEY)
    }

    override suspend fun persist(id: String) {
        dataStoreService.set(USER_IDENTIFIER_KEY, id)
    }

    override suspend fun clear() {
        dataStoreService.removeKey(USER_IDENTIFIER_KEY)
    }
}
