package com.moloco.sdk.internal.utils

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.CoroutineStart
import kotlinx.coroutines.launch
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext

/**
 * A wrapper around [CoroutineScope.launch] that returns [Unit],
 * allowing it to be used as an expression in functions with a [Unit] return type.
 */
@Suppress("NOTHING_TO_INLINE")
internal inline fun CoroutineScope.launchUnit(
    context: CoroutineContext = EmptyCoroutineContext,
    start: CoroutineStart = CoroutineStart.DEFAULT,
    noinline block: suspend CoroutineScope.() -> Unit
) {
    launch(context, start, block)
}
