package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.AdLoadTimeoutError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType
import kotlinx.coroutines.flow.StateFlow
import kotlin.time.Duration

interface AdLoad {
    val isLoaded: StateFlow<Boolean>

    // TODO. Support suspendable with cancellation instead of timeout parameter.
    //  That way Listener part and timeout parameter are unnecessary.
    fun load(timeout: Duration, listener: Listener?)

    interface Listener {
        fun onLoad()
        fun onLoadTimeout(timeoutError: AdLoadTimeoutError)
        fun onLoadError(internalError: MolocoAdSubErrorType)
    }
}
