package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import android.app.Activity
import android.os.Build.VERSION.SDK_INT
import android.view.View
import androidx.core.view.WindowCompat
import androidx.core.view.WindowInsetsCompat
import androidx.core.view.WindowInsetsControllerCompat

internal fun Activity.hideSystemUI() = with(window.decorView) {
    if (SDK_INT >= android.os.Build.VERSION_CODES.R) {
        hideSystemUIApi30Plus()
    } else {
        hideSystemUI()
    }
}

private fun Activity.hideSystemUIApi30Plus() {
    // Doesn't work correctly across all versions; at least on api 19, 21.
    WindowCompat.setDecorFitsSystemWindows(window, false)
    WindowInsetsControllerCompat(window, window.decorView).let { controller ->
        controller.hide(WindowInsetsCompat.Type.systemBars())
        controller.systemBarsBehavior =
            WindowInsetsControllerCompat.BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE
    }
}

@Suppress("DEPRECATION")
private fun View.hideSystemUI() {
    systemUiVisibility =
        View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY or
            View.SYSTEM_UI_FLAG_HIDE_NAVIGATION or
            View.SYSTEM_UI_FLAG_FULLSCREEN
}
