package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import android.content.Context
import android.content.Intent
import android.net.Uri
import androidx.browser.customtabs.CustomTabsIntent
import com.moloco.sdk.internal.MolocoLogger

fun interface ExternalLinkHandler {
    operator fun invoke(uri: String): Boolean
}

internal class ExternalLinkHandlerImpl(private val context: Context) : ExternalLinkHandler {
    override fun invoke(uri: String): Boolean {
        return context.tryStartCustomTabs(uri)
    }
}

// https://developer.chrome.com/multidevice/android/customtabs
private fun Context.tryStartCustomTabs(uri: String): Boolean {
    try {
        val customTabsIntent: CustomTabsIntent = CustomTabsIntent.Builder()
            .setUrlBarHidingEnabled(true)
            .build()
        customTabsIntent.intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        customTabsIntent.launchUrl(this, Uri.parse(uri))

        return true
    } catch (e: Exception) {
        MolocoLogger.error("Xenoss", "tryStartCustomTabs exception", e)
    }
    return false
}

