package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors

internal enum class StaticAdError : MolocoAdSubErrorType {
    STATIC_AD_UNKNOWN_ERROR,
    STATIC_AD_WEBVIEW_DATA_WITH_DEFAULT_BASE_URL_ERROR,
    STATIC_AD_WEBVIEW_RECEIVED_ERROR,
    STATIC_AD_WEBVIEW_RENDER_PROCESS_GONE_ERROR
    ;

    override val metricsRepresentation: String
        get() = name
}

internal enum class StaticBannerAdError : MolocoAdSubErrorType {
    STATIC_BANNER_AD_UNKNOWN_ERROR,
    STATIC_BANNER_AD_WEBVIEW_DATA_WITH_DEFAULT_BASE_URL_ERROR,
    STATIC_BANNER_AD_WEBVIEW_RECEIVED_ERROR,
    STATIC_BANNER_AD_WEBVIEW_RENDER_PROCESS_GONE_ERROR
    ;

    override val metricsRepresentation: String
        get() = name
}

internal fun StaticAdError.toStaticBannerError(): StaticBannerAdError {
    return when (this) {
        StaticAdError.STATIC_AD_UNKNOWN_ERROR -> StaticBannerAdError.STATIC_BANNER_AD_UNKNOWN_ERROR
        StaticAdError.STATIC_AD_WEBVIEW_DATA_WITH_DEFAULT_BASE_URL_ERROR -> StaticBannerAdError.STATIC_BANNER_AD_WEBVIEW_DATA_WITH_DEFAULT_BASE_URL_ERROR
        StaticAdError.STATIC_AD_WEBVIEW_RECEIVED_ERROR -> StaticBannerAdError.STATIC_BANNER_AD_WEBVIEW_RECEIVED_ERROR
        StaticAdError.STATIC_AD_WEBVIEW_RENDER_PROCESS_GONE_ERROR -> StaticBannerAdError.STATIC_BANNER_AD_WEBVIEW_RENDER_PROCESS_GONE_ERROR
    }
}


internal enum class StaticFullscreenAdError : MolocoAdSubErrorType {
    STATIC_FULLSCREEN_AD_UNKNOWN_ERROR,
    STATIC_FULLSCREEN_AD_WEBVIEW_DATA_WITH_DEFAULT_BASE_URL_ERROR,
    STATIC_FULLSCREEN_AD_WEBVIEW_RECEIVED_ERROR,
    STATIC_FULLSCREEN_AD_WEBVIEW_RENDER_PROCESS_GONE_ERROR
    ;

    override val metricsRepresentation: String
        get() = name
}

internal fun StaticAdError.toStaticFullscreenError(): StaticFullscreenAdError {
    return when (this) {
        StaticAdError.STATIC_AD_UNKNOWN_ERROR -> StaticFullscreenAdError.STATIC_FULLSCREEN_AD_UNKNOWN_ERROR
        StaticAdError.STATIC_AD_WEBVIEW_DATA_WITH_DEFAULT_BASE_URL_ERROR -> StaticFullscreenAdError.STATIC_FULLSCREEN_AD_WEBVIEW_DATA_WITH_DEFAULT_BASE_URL_ERROR
        StaticAdError.STATIC_AD_WEBVIEW_RECEIVED_ERROR -> StaticFullscreenAdError.STATIC_FULLSCREEN_AD_WEBVIEW_RECEIVED_ERROR
        StaticAdError.STATIC_AD_WEBVIEW_RENDER_PROCESS_GONE_ERROR -> StaticFullscreenAdError.STATIC_FULLSCREEN_AD_WEBVIEW_RENDER_PROCESS_GONE_ERROR
    }
}