package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.media

/**
 * Default configuration to be used for the media ad load if
 * the backend does not override the configuration.
 */
internal val DefaultMediaConfig = MediaConfig(
    chunkSize = 500 * 1024, // 500Kb
    isStreamingEnabled = false,
    minStreamingPlayableDurationOnTimeoutSecs = 1.0,
    mediaCacheDiskCleanUpLimit = 200 * 1024 * 1024, // Clear disk if cache size >=200MB
)

/**
 * Configuration for ad media load.
 *
 * @param chunkSize Size of each chunk in bytes that are to be downloaded from CDN or backend resource.
 * @param isStreamingEnabled Whether streaming is enabled. If true, media will be streamed from CDN or backend resource.
 * @param minStreamingPlayableDurationOnTimeoutSecs - When the ad load timeout is reached when streaming the content,
 *       use this playable duration to determine if the ad load should succeed or fail
 *       If the ad load does not have min of this playable duration downloaded, then fail
 *       For eg - 2.5 means that the ad should have 2.5s worth of playable bytes downloaded on
 *       timeout and if <2.5s of duration is detected, then fail the download with timeout
 * @param mediaCacheDiskCleanUpLimit Disk clean up limit for media cache in bytes. If cache size exceeds this limit, cache will be cleared.
 *
 */
internal data class MediaConfig(
    val chunkSize: Int,
    val isStreamingEnabled: Boolean,
    val minStreamingPlayableDurationOnTimeoutSecs: Double,
    val mediaCacheDiskCleanUpLimit: Int,
)
