package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid

import android.content.Context
import android.graphics.Rect

/**
 * Screen metrics needed by the MRAID container.
 *
 * Each rectangle is stored using both it's original and scaled coordinates to avoid allocating
 * extra memory that would otherwise be needed to do these conversions.
 */
// TODO. Refactor. Idk looks to complex. Need to revise later. "Extra memory"..., Really?
internal class MraidScreenMetrics(context: Context) {

    private val context: Context = context.applicationContext

    private val screenRect = Rect()
    private val screenRectDips = Rect()

    private val rootViewRect = Rect()
    private val rootViewRectDips = Rect()

    private val currentAdRect = Rect()
    private val currentAdRectDips = Rect()

    private val defaultAdRect = Rect()
    private val defaultAdRectDips = Rect()

    private fun convertToDips(sourceRect: Rect, outRect: Rect) {
        outRect.set(
            Dips.pixelsToIntDips(sourceRect.left.toFloat(), context),
            Dips.pixelsToIntDips(sourceRect.top.toFloat(), context),
            Dips.pixelsToIntDips(sourceRect.right.toFloat(), context),
            Dips.pixelsToIntDips(sourceRect.bottom.toFloat(), context)
        )
    }

    fun setScreenSize(width: Int, height: Int) {
        screenRect.set(0, 0, width, height)
        convertToDips(screenRect, screenRectDips)
    }

    fun setRootViewPosition(x: Int, y: Int, width: Int, height: Int) {
        rootViewRect.set(x, y, x + width, y + height)
        convertToDips(rootViewRect, rootViewRectDips)
    }

    fun setCurrentAdPosition(x: Int, y: Int, width: Int, height: Int) {
        currentAdRect.set(x, y, x + width, y + height)
        convertToDips(currentAdRect, currentAdRectDips)
    }

    fun setDefaultAdPosition(x: Int, y: Int, width: Int, height: Int) {
        defaultAdRect.set(x, y, x + width, y + height)
        convertToDips(defaultAdRect, defaultAdRectDips)
    }

    fun getScreenRectDips(): Rect {
        return screenRectDips
    }

    fun getRootViewRect(): Rect {
        return rootViewRect
    }

    fun getRootViewRectDips(): Rect {
        return rootViewRectDips
    }

    fun getDefaultAdRect(): Rect {
        return defaultAdRect
    }

    fun getDefaultAdRectDips(): Rect {
        return defaultAdRectDips
    }

    fun getCurrentAdRect(): Rect {
        return currentAdRect
    }

    fun getCurrentAdRectDips(): Rect {
        return currentAdRectDips
    }
}
