package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui

import android.animation.AnimatorSet
import android.animation.ObjectAnimator
import android.animation.ValueAnimator
import android.view.View
import android.view.View.VISIBLE
import androidx.core.animation.doOnStart

// TODO. Rename.
internal fun View.animateAppearanceAndOscillation() {
    val view = this

    val pulseDuration = 750L
    val pulseMinVal = 1.0f
    val pulseMaxVal = 1.05f
    val pulseRepeatMode = ValueAnimator.REVERSE
    val pulseRepeatCount = ValueAnimator.INFINITE

    val pulseX =
        ObjectAnimator.ofFloat(view, "scaleX", pulseMinVal, pulseMaxVal)
            .apply {
                duration = pulseDuration
                repeatMode = pulseRepeatMode
                repeatCount = pulseRepeatCount
            }

    val pulseY =
        ObjectAnimator.ofFloat(view, "scaleY", pulseMinVal, pulseMaxVal)
            .apply {
                duration = pulseDuration
                repeatMode = pulseRepeatMode
                repeatCount = pulseRepeatCount
            }

    val singleDownscaleX =
        ObjectAnimator.ofFloat(view, "scaleX", pulseMaxVal, pulseMinVal)
            .apply {
                duration = pulseDuration
            }

    val singleDownscaleY =
        ObjectAnimator.ofFloat(view, "scaleY", pulseMaxVal, pulseMinVal)
            .apply {
                duration = pulseDuration
            }

    val appearanceMinVal = 0.0f
    val appearanceMaxVal = pulseMaxVal
    val appearanceDuration = 250L

    val appearanceX =
        ObjectAnimator.ofFloat(view, "scaleX", appearanceMinVal, appearanceMaxVal)
            .apply {
                duration = appearanceDuration
            }

    val appearanceY =
        ObjectAnimator.ofFloat(view, "scaleY", appearanceMinVal, appearanceMaxVal)
            .apply {
                duration = appearanceDuration
            }

    val appearance = AnimatorSet().apply {
        play(appearanceX).with(appearanceY)
    }

    val singleDownscale = AnimatorSet().apply {
        play(singleDownscaleX).with(singleDownscaleY)
    }

    val pulse = AnimatorSet().apply {
        play(pulseX).with(pulseY)
    }

    AnimatorSet().apply {
        doOnStart {
            view.scaleX = appearanceMinVal
            view.scaleY = appearanceMinVal
            view.visibility = VISIBLE
        }

        playSequentially(appearance, singleDownscale, pulse)

        startDelay = 1000L
    }.start()
}
