package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui

import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material.Button
import androidx.compose.material.ButtonDefaults
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import coil.compose.AsyncImage

/**
 * DEC stands for Double Endcard.
 * [more info](https://docs.google.com/document/d/1NX-lSe5yFC-Alcn7gViGeDNXGW4GPGPyi_tfNNs9u34/edit#heading=h.7mizpdq5e8ie)
 */
@Composable
internal fun DEC(
    modifier: Modifier = Modifier,
    appIconUri: String?,
    appName: String?,
    cta: String?,
    onClick: () -> Unit
) {
    Column(
        modifier = modifier
            .fillMaxSize()
            .background(Color.Black)
            .clickable(onClick = onClick),
        verticalArrangement = Arrangement.Center,
        horizontalAlignment = Alignment.CenterHorizontally
    ) {
        AsyncImage(
            modifier = Modifier.size(128.dp),
            model = appIconUri,
            contentDescription = null
        )

        if (appName != null) {
            Spacer(modifier = Modifier.height(12.dp))

            Text(
                text = appName,
                color = Color.White,
                maxLines = 2,
                overflow = TextOverflow.Ellipsis,
                fontWeight = FontWeight.Bold
            )
        }

        Spacer(modifier = Modifier.height(8.dp))

        Button(
            colors = ButtonDefaults.buttonColors(
                backgroundColor = CTAColor,
                contentColor = TextColor
            ),
            shape = CircleShape,
            onClick = onClick
        ) {
            Text(
                text = cta ?: "",
                color = TextColor,
                fontWeight = FontWeight.Bold,
                maxLines = 1,
                overflow = TextOverflow.Ellipsis
            )
        }
    }
}

private val CTAColor = Color(red = 71, green = 118, blue = 238)
private val TextColor = Color.White

@Preview
@Composable
private fun DECPreview() {
    MaterialTheme {
        DEC(
            appIconUri = "https://play-lh.googleusercontent.com/7M9FYlUnscfJQZqHE4Yz2HNEzESl3QOUEVAOD3YzC32HuMsbropV8h_tPpaNdRmqrA=w480-h960",
            appName = "MONOPOLY GO!",
            cta = "GET",
            onClick = { }
        )
    }
}
