package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.modifiers

import android.annotation.SuppressLint
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.onGloballyPositioned
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.ScreenUtils.isNotZero
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.ScreenUtils.toButton
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService.UserInteraction.Button

/**
 * @param modifier -> Existing modifier to which the button positioning listener should be attached
 * @param savedStateButton -> Existing saved state of the button in the composable. This is to ensure deduping
 * @param updateButtonState -> Callback to provide the updated state of the button if the button's layout has changed
 */
@SuppressLint("ModifierFactoryExtensionFunction")
internal fun buttonGlobalPositionModifier(
    modifier: Modifier,
    savedStateButton: Button,
    updateButtonState: (Button) -> Unit
) = modifier.onGloballyPositioned {
    val button = it.toButton(savedStateButton.buttonType)
    // Compose can re-execute the composable thereby triggering multiple
    // onGloballyPositioned calls, which are un-neccessary for us to capture state
    // unless the button layout has actually changed
    if (button.isNotZero() && button != savedStateButton) {
        updateButtonState(button)
    }
}
