package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model

class Vast(
    val ads: List<Ad>,
    val errorUrl: String?,
    val version: String?
)

class Ad(
    val id: String?,
    val sequence: Int?,
    val child: AdChild
)

sealed class AdChild {
    class InLine(
        val inline: com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.InLine
    ) : AdChild()
    class Wrapper(
        val wrapper: com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.Wrapper
    ) : AdChild()
}

class InLine(
    val adSystem: AdSystem?,
    val adTitle: String?,
    val description: String?,
    val advertiser: String?,
    val pricing: Pricing?,
    val impressions: List<Impression>,
    val errorUrls: List<String>,
    val creatives: List<Creative>
)

class Wrapper(
    val vastAdTagUrl: String,
    val followAdditionalWrappers: Boolean?,
    val adSystem: AdSystem?,
    val impressions: List<Impression>,
    val errorUrls: List<String>,
    val creatives: List<Creative>
)

class AdSystem(val name: String?, val version: String?)

class Pricing(val model: String?, val currency: String?)

class Impression(val id: String?, val impressionUrl: String)

data class Creative(
    val id: String?,
    val sequence: Int?,
    val adId: String?,
    val apiFramework: String?,
    val child: CreativeChild
)

sealed class CreativeChild {
    class Linear(
        val linear: com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.Linear
    ) : CreativeChild()
    class Companions(val companions: List<Companion>) : CreativeChild()
}

// TODO. Create standalone WrapperLinear class since it can contain only click (no clickthrough) and video tracking.
class Linear(
    val skipOffset: Offset?,
    val adParameters: AdParameters?,
    val durationMillis: Long?,
    val mediaFiles: List<MediaFile>,
    val trackingList: List<Tracking>,
    val videoClicks: VideoClicks?,
    val icons: List<Icon>
)

class AdParameters(val value: String, val isXmlEncoded: Boolean?)

class MediaFile(
    val mediaFileUrl: String,
    val id: String?,
    val isProgressiveDelivery: Boolean,
    val type: String,
    val widthPx: Int?,
    val heightPx: Int?,
    val codec: String?,
    val bitrate: Int?,
    val minBitrate: Int?,
    val maxBitrate: Int?,
    val isScalable: Boolean?,
    val apiFramework: String?
)

class VideoClicks(
    val clickThrough: VideoClick?,
    val clickTrackingList: List<VideoClick>,
    val customClickList: List<VideoClick>
)

class VideoClick(val id: String?, val url: String)

class Icon(
    val program: String?,
    val widthPx: Int?,
    val heightPx: Int?,
    val apiFramework: String?,
    val offset: Offset?,
    val durationMillis: Long?,
    val clicks: IconClicks?,
    val viewTrackingUrlList: List<String>,
    val resource: VastResource
)

class IconClicks(
    val clickThroughUrl: String,
    val clickTrackingUrlList: List<String>,
)

class Companion(
    val id: String?,
    val widthPx: Int?,
    val heightPx: Int?,
    val altText: String?,
    val apiFramework: String?,
    val clicks: CompanionClicks?,
    val adParameters: AdParameters?,
    val creativeViewTrackingList: List<Tracking>,
    val resources: List<VastResource>
)

class CompanionClicks(
    val clickThroughUrl: String,
    val clickTrackingUrls: List<String>
)

/*

inifoiite loop (used url or 5 tries or followAdditionalWrappers: false)
The!video!player!should!be!aware!of!infinite!Wrapper!loops!and!be!prepared!to!respond
either!with!an!<Error> or!other!appropriate!action.

The!most!important!difference!between!a!Wrapper!Linear!creative!and!an!Inline!one!is!that!a!Wrapper!
Linear!creative!is!absent!of!any!media!files.!The!only!elements!allowed!in!a!Wrapper!Linear!creative!are!
<VideoClicks> and <TrackingEvents>.!T

The!<CompanionClickTracking> element!can!be!used!in!a!Wrapper!to!track!clicks!
on!InLine!Companion!creative.!However, correct!association!of!the!Inline!clickthrough!to!
the!appropriate!Wrapper!tracking!element may!not!be!an!exact!match!when!multiple!
Companions!are!offered.

When!multiple!Companion!creative!are!included!in!the!Inline!response,!identifying!which!Companion
clickthrough!event!should!be!associated!with!the!Wrapper!tracking!element!can!be!difficult.!The!video!
player!may!associate!Inline!Companion!clickthrough!activity!to!Wrapper!<CompanionClickTracking>
events!at!its!own!discretion.!The!Companion!id attribute!may!be!a!useful!association!if!provided,!or!the!
video!player!can!match!width and!height attributes.

TLDR companion tracking may involve ids and whatever, whereas iniline creative just consumes all availble tracks.

The value for skipoffset is a time value in the format
HH:MM:SS or
HH:MM:SS.mmm or
a percentage in the format n%

<Duration>00:00:30</Duration>
Or alternately:
<Duration>00:00:30.000</Duration>

 */
