package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model

sealed class VastResource {
    class Html(val resource: HtmlResource) : VastResource()
    class IFrame(val resource: IFrameResource) : VastResource()
    class Static(val resource: StaticResource) : VastResource()
}

class HtmlResource(val resource: String)
class IFrameResource(val resource: String)
class StaticResource(val resource: String, val creativeType: CreativeType)
enum class CreativeType { Image, JS }
