package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.DEC
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.Offset
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.model.VastResource
import java.io.File

data class Ad(
    val linear: Linear,
    val companion: Companion?,
    val impressionTracking: List<String>,
    val errorTracking: List<String>,
    /**
     * Extension to support double endcard.
     */
    val dec: DEC? = null
)

data class Linear(
    val skipOffset: Offset?,
    val localMediaResource: File,
    val localMediaResourceBitrate: Int?,
    val networkMediaResource: String,
    val clickThroughUrl: String?,
    val tracking: LinearTracking,
    val icon: Icon?
)

class LinearTracking(
    val click: List<String>,
    val creativeView: List<String>,
    val start: List<String>,
    val firstQuartile: List<String>,
    val midpoint: List<String>,
    val thirdQuartile: List<String>,
    val complete: List<String>,
    val mute: List<String>,
    val unMute: List<String>,
    val pause: List<String>,
    val resume: List<String>,
    val rewind: List<String>,
    val skip: List<String>,
    val closeLinear: List<String>,
    val progress: List<LinearProgressTracking>
)

class LinearProgressTracking(val url: String, val offset: Offset)

class Icon(
    val resource: VastResource,
    val widthPx: Int,
    val heightPx: Int,
    val clickThroughUrl: String?,
    val clickTracking: List<String>,
    val viewTracking: List<String>,
    val durationMillis: Long?,
    val offset: Offset?
)

class Companion(
    val resource: VastResource,
    val widthPx: Int,
    val heightPx: Int,
    val clickThroughUrl: String?,
    val clickTracking: List<String>,
    val creativeViewTracking: List<String>
)
