package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Destroyable
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidFullScreenViewModel
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.ButtonRecorder
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.GoNextAction
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.companion.CompanionViewModel
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.dec.DECViewModel
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.linear.LinearViewModel
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.StateFlow

interface AdController : AdViewModel, Destroyable {
    fun show()

    // Todo. Implement dismissed state (true/false) instead of hidden event flow (just event is not a proper solution here),
    val event: Flow<AdControllerEvent>
}

sealed class AdControllerEvent {
    object LinearDisplayStarted : AdControllerEvent()
    object CompanionDisplayStarted : AdControllerEvent()
    object DECDisplayStarted : AdControllerEvent()
    object Skip : AdControllerEvent()
    object Replay : AdControllerEvent()
    class Error(val error: MolocoAdSubErrorType) : AdControllerEvent()
    object Complete : AdControllerEvent()
    object ClickThrough : AdControllerEvent()
    object Dismiss : AdControllerEvent()
}

// TODO. Definitely rename to something like state/interactor whatever.
// It's the interface for user interactions.
interface AdViewModel : GoNextAction, ButtonRecorder {
    val canReplay: StateFlow<Boolean>
    fun onReplay()

    /**
     * "Go next" action moves to the next ad part (linear/video, companion/endcard, companion/DEC)
     * or finishes/closes/dismisses the ad if there's no ad parts to show left.
     *
     */
    fun goNextAdPartOrDismissAd()

    val ctaAvailable: StateFlow<Boolean>
    fun onCTA()

    val currentAdPart: StateFlow<AdPart?>

    sealed class AdPart(open val isLastAdPart: Boolean) {
        data class Linear(
            val viewModel: LinearViewModel,
            override val isLastAdPart: Boolean
        ) : AdPart(isLastAdPart)
        data class Companion(
            val viewModel: CompanionViewModel,
            override val isLastAdPart: Boolean
        ) : AdPart(isLastAdPart)
        data class DEC(
            val viewModel: DECViewModel,
            override val isLastAdPart: Boolean
        ) : AdPart(isLastAdPart)
        data class Mraid(
            val viewModel: MraidFullScreenViewModel,
            override val isLastAdPart: Boolean
        ) : AdPart(isLastAdPart)
    }
}
