package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose

import androidx.compose.animation.Crossfade
import androidx.compose.foundation.layout.BoxScope
import androidx.compose.foundation.layout.padding
import androidx.compose.material.Text
import androidx.compose.material.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.PlaybackProgress

typealias PlaybackControl = @Composable BoxScope.(
    // current video player state parameters.
    isPlaying: Boolean,
    progress: PlaybackProgress,
    // user commands for player: play/pause/replay.
    onShouldPlay: (shouldPlay: Boolean) -> Unit,
    onShouldReplay: () -> Unit
) -> Unit

/**
 * Default behaviour playback control:
 * when media is playing - request media pause; otherwise - resume playback.
 * If media playback is finished/completer - request media replay.
 */
@Composable
fun defaultPlaybackControl(
    content: DefaultPlaybackControlUI = DefaultPlaybackControlTextUI
): PlaybackControl = { isPlaying, progress, onShouldPlay, onShouldReplay ->

    val onClick = {
        if (progress is PlaybackProgress.Finished) {
            onShouldReplay()
        } else {
            onShouldPlay(!isPlaying)
        }
    }

    content(isPlaying, onClick)
}

typealias DefaultPlaybackControlUI =
    @Composable
    BoxScope.(isPlaying: Boolean, onClick: () -> Unit) -> Unit

val DefaultPlaybackControlTextUI: DefaultPlaybackControlUI = { isPlaying, onClick ->
    Crossfade(
        modifier = Modifier
            .align(Alignment.BottomCenter)
            .padding(4.dp),
        targetState = isPlaying
    ) {
        TextButton(onClick) {
            Text(if (it) "Pause" else "Play")
        }
    }
}
