package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose

import androidx.compose.foundation.layout.size
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import coil.compose.AsyncImage
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.PreparedVastResource

@Composable
fun VastResourceImage(imageResource: PreparedVastResource.Image, modifier: Modifier = Modifier) {
    AsyncImage(
        modifier = modifier.size(imageResource.w.dp, imageResource.h.dp),
        model = imageResource.imageUrl,
        contentDescription = null
    )
}
