package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.dec

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.ButtonTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.VastTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService

internal class DECVastTracker(
    private val customUserEventBuilderService: CustomUserEventBuilderService,
    private var clickTracking: List<String>?,
    private var impressionTracking: List<String>?,
    private var skipToDECTracking: List<String>?,
    private val buttonTracker: ButtonTracker = ButtonTracker(),
    private val vastTracker: VastTracker = VastTracker()
) {

    fun trackButtonRender(button: CustomUserEventBuilderService.UserInteraction.Button) {
        buttonTracker.onButtonRendered(button)
    }

    fun trackButtonUnRender(
        buttonType: CustomUserEventBuilderService.UserInteraction.Button.ButtonType
    ) {
        buttonTracker.onButtonUnRendered(buttonType)
    }

    fun trackClick(position: CustomUserEventBuilderService.UserInteraction.Position) {
        clickTracking?.let {
            vastTracker.trackClick(
                urls = it,
                customUserEventBuilderService = customUserEventBuilderService,
                renderedButtons = buttonTracker.renderedButtons(),
                lastClickPosition = position
            )
            clickTracking = null
        }
    }

    fun trackImpression() {
        impressionTracking?.let {
            vastTracker.track(it)
            impressionTracking = null
        }
    }

    fun trackSkipToDEC() {
        skipToDECTracking?.let {
            vastTracker.track(it)
            skipToDECTracking = null
        }
    }
}
