package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.videoplayer

import android.os.Build
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Destroyable

internal class SimplifiedExoPlayerLifecycleHandler(
    private val lifecycle: Lifecycle,
    onExoResume: () -> Unit,
    onExoPause: () -> Unit,
) : Destroyable {

    private val lifecycleObserver = LifecycleEventObserver { _, event ->
        // For more details check out "Playing nice with the Activity lifecycle" section
        // https://developer.android.com/codelabs/exoplayer-intro#2
        // TL;DR it's for supporting releasing of media codecs for split window app sessions.
        when (event) {
            Lifecycle.Event.ON_START -> if (Build.VERSION.SDK_INT > 23) {
                onExoResume()
            }
            Lifecycle.Event.ON_RESUME -> if (Build.VERSION.SDK_INT <= 23) {
                onExoResume()
            }
            Lifecycle.Event.ON_PAUSE -> if (Build.VERSION.SDK_INT <= 23) {
                onExoPause()
            }
            Lifecycle.Event.ON_STOP -> if (Build.VERSION.SDK_INT > 23) {
                onExoPause()
            }
            else -> {
                // ...
            }
        }
    }

    init {
        lifecycle.addObserver(lifecycleObserver)
    }

    override fun destroy() {
        lifecycle.removeObserver(lifecycleObserver)
    }
}
