package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.videoplayer

import android.view.View
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.Destroyable
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.VastAdShowError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.PlaybackProgress
import kotlinx.coroutines.flow.StateFlow

/**
 * Represents the state of the video player.
 * @param isPlaying true if the video is actively playing, false otherwise.
 * @param isVisible true if the video player is visible, false otherwise.
 * @param hasMore true if the player has more of the video content to play, false otherwise.
 *                This can be true with isPlaying false when the content is being streamed and not yet buffered
 */
data class PlayingState(val isPlaying: Boolean,
                        val isVisible: Boolean = true,
                        val hasMore: Boolean = true,)
interface VideoPlayer : Destroyable {
    val playerView: View?

    var isMute: Boolean

    var uriSource: String?

    fun play()
    fun seekTo(positionMillis: Long)
    fun pause()

    val isPlaying: StateFlow<PlayingState>

    val playbackProgress: StateFlow<PlaybackProgress>

    val lastError: StateFlow<VastAdShowError?>
}
